-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

return function ()
	local _ffi = require('ffi')

	-- wrap StartMessage:getActionName in ffi.string
	local startMessageMetatable = getMetatable('StartMessageUserData')
	local startMessageMetatable_getActionName = startMessageMetatable.getActionName
	function startMessageMetatable:getActionName(...)
		return _ffi.string(startMessageMetatable_getActionName(self, ...))
	end

	-- wrap StopMessage:getActionName in ffi.string
	local StopMessageMetatable = getMetatable('StopMessageUserData')
	local StopMessageMetatable_getActionName = StopMessageMetatable.getActionName
	function StopMessageMetatable:getActionName(...)
		return _ffi.string(StopMessageMetatable_getActionName(self, ...))
	end

	-- wrap InstantaneousActionMessage:getActionName in ffi.string
	local InstantaneousActionMessageMetatable = getMetatable('InstantaneousActionMessageUserData')
	local InstantaneousActionMessageMetatable_getActionName = InstantaneousActionMessageMetatable.getActionName
	function InstantaneousActionMessageMetatable:getActionName(...)
		return _ffi.string(InstantaneousActionMessageMetatable_getActionName(self, ...))
	end
end