-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local MetricsManager = require('MetricsManager')
local Metric = require('Metric')

local SimplePrinter = require('metricCallbacks.SimplePrinter')
local MetricAccumulator = require('metricCallbacks.MetricAccumulator')
local CallbackComposer = require('metricCallbacks.CallbackComposer')
local MovingAveragePreprocessor = require('preprocessors.MovingAveragePreprocessor')

local mm = MetricsManager:new()

mm:addMetric(
	{
		name = 'Startup',
		markers =
		{
			{
				name = 'IGN_STRT',
				type = Metric.MessageTypes.INSTANTANEOUS
			},
			{
				name = 'IGN_Core_Load',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Load',
				type = Metric.MessageTypes.STOP
			},
			{
				name = 'IGN_Core_Run',
				type = Metric.MessageTypes.START
			}
		},
		callback = SimplePrinter(log.info)
	})

mm:addMetric(
	{
		name = 'IGNITION_STARTUP_DURATION',
		markers =
		{
			{
				name = 'IGN_Core_ENGN_Init',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_ENGN_Init',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch=1
			}
		},
		callback = MetricAccumulator(mm)
	})

mm:addMetric(
	{
		name = 'IGNITION_STARTUP_DURATION.{}',
		markers =
		{
			{
				name = 'IGN_Core_ENGN_Init_{}',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_ENGN_Init_{}',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch=1
			}
		},
		callback = MetricAccumulator(mm)
	})

mm:addMetric(
	{
		name = 'LoadPackage.{}',
		markers =
		{
			{
				name = 'IGN_Core_Load_Package_{}',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Load_Package_{}',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch=1
			}
		},
		callback = SimplePrinter(log.info)
	})

mm:addMetric(
	{
		name = 'LoadPlugin.{}',
		markers =
		{
			{
				name = 'IGN_Core_Load_Plugin_{}',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Load_Plugin_{}',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch=1
			}
		},
		callback = MetricAccumulator(mm)
	})

mm:addMetric(
	{
		name = 'StartPlugin.{}',
		markers =
		{
			{
				name = 'IGN_Core_Start_Plugin_{}',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Start_Plugin_{}',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch=1
			}
		},
		callback = MetricAccumulator(mm)
	})

local avgImageLoadPreprocessor = MovingAveragePreprocessor.new(30)
mm:addMetric(
	{
		name = "AverageImageLoad",
		markers =
		{
			{
				name = 'IGN_Scene_IMG_LOAD',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Scene_IMG_LOAD',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = CallbackComposer(
			{MetricAccumulator(mm)}, avgImageLoadPreprocessor),
		allowConcurrentInstances = true
	})
mm:addMetric(
	{
		name = "EnterBackground",
		markers =
		{
			{
				name = 'IGN_Core_Enter_Background',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Enter_Background',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "EnterForeground",
		markers =
		{
			{
				name = 'IGN_Core_Enter_Foreground',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Enter_Foreground',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "ForegroundToForeground",
		markers =
		{
			{
				name = 'IGN_Core_Foreground_To_Foreground',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Foreground_To_Foreground',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "EnterBackground.Stark",
		markers = 
		{
			{
				name = 'IGN_Core_Enter_Background_com.amazon.ignition.app.stark',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Enter_Background_com.amazon.ignition.app.stark',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "EnterBackground.Renderer",
		markers = 
		{
			{
				name = 'IGN_Core_Enter_Background_com.amazon.ignition.framework.renderer',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Enter_Background_com.amazon.ignition.framework.renderer',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "EnterForeground.Stark",
		markers = 
		{
			{
				name = 'IGN_Core_Enter_Foreground_com.amazon.ignition.app.stark',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Enter_Foreground_com.amazon.ignition.app.stark',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "EnterForeground.Renderer",
		markers = 
		{
			{
				name = 'IGN_Core_Enter_Foreground_com.amazon.ignition.framework.renderer',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Enter_Foreground_com.amazon.ignition.framework.renderer',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "ForegroundToForeground.Stark",
		markers = 
		{
			{
				name = 'IGN_Core_Foreground_To_Foreground_com.amazon.ignition.app.stark',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Foreground_To_Foreground_com.amazon.ignition.app.stark',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
mm:addMetric(
	{
		name = "ForegroundToForeground.Renderer",
		markers = 
		{
			{
				name = 'IGN_Core_Foreground_To_Foreground_com.amazon.ignition.framework.renderer',
				type = Metric.MessageTypes.START
			},
			{
				name = 'IGN_Core_Foreground_To_Foreground_com.amazon.ignition.framework.renderer',
				type = Metric.MessageTypes.STOP,
				indexOfMarkerIdToMatch = 1
			}
		},
		callback = MetricAccumulator(mm)
	})
return mm
