/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef METRICS_METRICS_BIDINGS_EXPOSE_CPP_TO_LUA_MESSAGE_LUA_BINDING_H_
#define METRICS_METRICS_BIDINGS_EXPOSE_CPP_TO_LUA_MESSAGE_LUA_BINDING_H_

#include "timeline/utils/ITimelineListener.h"
#include "metrics/bindings/exposeCppToLua/BringTypesIntoNamespace.h"

#include <ffi/LuaFFIUserData.h>

namespace ignition
{

CREATE_FFI_USER_DATA(StartMessage, metrics);
CREATE_FFI_USER_DATA(StopMessage, metrics);
CREATE_FFI_USER_DATA(InstantaneousActionMessage, metrics);

namespace metrics
{

extern "C"
{

using core::ReflectableValueMapUserData;
using core::MilliTime_t;
using core::ActionId;

/* @begin_ffi_externs */

typedef struct ReflectableValueUserData ReflectableValueUserData;
typedef struct ReflectableValueMapUserData ReflectableValueMapUserData;
typedef struct StartMessageUserData StartMessageUserData;
typedef struct StopMessageUserData StopMessageUserData;
typedef struct InstantaneousActionMessageUserData InstantaneousActionMessageUserData;

StartMessageUserData* metrics_StartMessage_new(
		const char* actionName,
		const char* label,
		ReflectableValueMapUserData* metadata,
		uint32_t startTime,
		int32_t id);
void metrics_StartMessage_gc(StartMessageUserData* self);
const char* metrics_StartMessage_getActionName(StartMessageUserData* self);
ReflectableValueMapUserData* metrics_StartMessage_getMetadata(StartMessageUserData* self);
double metrics_StartMessage_getStartTime(StartMessageUserData* self);
uint32_t metrics_StartMessage_getActionId(StartMessageUserData* self);

StopMessageUserData* metrics_StopMessage_new(
		const char* actionName,
		const char* label,
		ReflectableValueMapUserData* metadata,
		uint32_t startTime,
		uint32_t stopTime,
		int32_t id);
void metrics_StopMessage_gc(StopMessageUserData* self);
const char* metrics_StopMessage_getActionName(StopMessageUserData* self);
ReflectableValueMapUserData* metrics_StopMessage_getMetadata(StopMessageUserData* self);
double metrics_StopMessage_getStartTime(StopMessageUserData* self);
double metrics_StopMessage_getStopTime(StopMessageUserData* self);
uint32_t metrics_StopMessage_getActionId(StopMessageUserData* self);

InstantaneousActionMessageUserData* metrics_InstantaneousActionMessage_new(
		const char* actionName,
		const char* label,
		ReflectableValueMapUserData* metadata,
		int32_t id);
void metrics_InstantaneousActionMessage_gc(InstantaneousActionMessageUserData* self);
const char* metrics_InstantaneousActionMessage_getActionName(
		InstantaneousActionMessageUserData* self);
ReflectableValueMapUserData* metrics_InstantaneousActionMessage_getMetadata(
		InstantaneousActionMessageUserData* self);
double metrics_InstantaneousActionMessage_getTime(
		InstantaneousActionMessageUserData* self);

/* @end_ffi_externs */

} // extern "C"

} // namespace metrics
} // namespace ignition

#endif // METRICS_METRICS_BIDINGS_EXPOSE_CPP_TO_LUA_MESSAGE_LUA_BINDING_H_
