/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef METRICS_METRIC_SAMPLES_H_
#define METRICS_METRIC_SAMPLES_H_

#include <DataStructures.h>
#include <IgnitionStdint.h>
#include <string>

namespace ignition
{
namespace metrics
{

typedef core::unordered_map< std::string, core::vector<double> > MetricSamples;

struct MetricSamplesPollingState
{
	MetricSamples latestSamples;
	uint32_t nextStartIndex;

	MetricSamplesPollingState() : nextStartIndex(0) {}
};

} // namespace metrics
} // namespace ignition

#endif // METRICS_METRIC_SAMPLES_H_
