-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

return function (fn, ...)
	local theArgs = {...}
	local theReturn = nil
	local theErr = nil
	local theTraceback = nil

	local function makeCall()
		theReturn = fn(unpack(theArgs))
	end

	local function onError(err)
		theTraceback = debug.traceback()
		theErr = err
	end

	local status = xpcall(makeCall, onError)

	if not status then
		error(string.format("%s\n\n%s", theErr, theTraceback))
	end

	return theReturn
end