-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

--[[
-- Applies Version Manager Binding Extension Augmentations
--]]
return function ()
	local _ffi = require('ffi')
	
	-- Create global convenience getter for the PluginVersionManager
	local versionManagerMetatable = getMetatable('PluginVersionManagerSharedPtrUserData')
	_G.versionManager = 
	{
		getInstance = versionManagerMetatable.getInstance
	}
	
	-- Augment the string return type from the VersionTable:getVersionFor
	local versionTableMetatable = getMetatable('VersionTableSharedPtrUserData')
	local versionTableMetatable_getVersionFor = versionTableMetatable.getVersionFor
	function versionTableMetatable:getVersionFor(...)	
		return _ffi.string(versionTableMetatable_getVersionFor(self, ...))
	end
end