-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local WeakRefMetatable =
{
	__mode = "v",
	__call = function(self) return self.ref end,
	__eq = function(self, other)
		if not other.isWeakRef then
			return false
		end
		return self.ref == other.ref
	end
}

local WeakRef = function(obj)
	return setmetatable({ref = obj, isWeakRef = true}, WeakRefMetatable)
end

return WeakRef
