-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local TableFinalizer = function(table, finalizerFunc)
	-- Ideally we'd create a "__gc" metamethod in the table itself, but this
	-- is not supported for tables in Lua5.1 or LuaJIT (only for userdata), so
	-- we're using the "newproxy" workaround to create an empty userdata
	local finalizer = newproxy(true)
	getmetatable(finalizer).__gc = function()
		finalizerFunc(table)
	end
	return finalizer
end

return TableFinalizer
