local NumberComparator = {}

local DEFAULT_TOLERANCE = 0.0015

NumberComparator.almostEqual = function(old, new, normalizedFloatTolerance)
	if old == new then
		-- optimise for common use case
		return true
	else
		normalizedFloatTolerance = normalizedFloatTolerance or DEFAULT_TOLERANCE

		return math.abs(new - old) < (normalizedFloatTolerance * math.min(new, old))
	end
end

NumberComparator.almostEqualVec3 = function(old, new, normalizedTolerance)
	return NumberComparator.almostEqual(old.x, new.x, normalizedTolerance) and
			NumberComparator.almostEqual(old.y, new.y, normalizedTolerance) and
			NumberComparator.almostEqual(old.z, new.z, normalizedTolerance)
end

NumberComparator.almostEqualVec4 = function(old, new, normalizedTolerance)
	return NumberComparator.almostEqualVec3(old, new, normalizedTolerance) and
			NumberComparator.almostEqual(old.w, new.w, normalizedTolerance)
end

return NumberComparator
