-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local LuaFileLoader = class(function(self, basePath)
	self._basePath = basePath
end)

function LuaFileLoader:load(filePath)
	local fullPath = self._basePath .. filePath
	local contents, err = loadfile(fullPath)
	
	if contents == nil then
		error('\n\n' ..
			'Could not require ' .. filePath .. '. ' ..
			'Error was: ' .. tostring(err) .. 
			'\n\n' .. debug.traceback())
	else
		return contents()
	end
end

return LuaFileLoader

