-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local function validateComponent(value, label)
	local isValid = (type(value) == "number") and (value >= 0) and (value <= 255)

	if not isValid then
		log.error("RGBA." .. label .. " must be a number between 0 and 255.")
	end

	return isValid
end

local function validate(rgbaTable)
	return (type(rgbaTable) == "table") and
			validateComponent(rgbaTable.r, "r") and
			validateComponent(rgbaTable.g, "g") and
			validateComponent(rgbaTable.b, "b") and
			(rgbaTable.a == nil or validateComponent(rgbaTable.a, "a"))
end

return function(rgbaTable)
	if not validate(rgbaTable) then
		return nil
	end

	local r = rgbaTable.r / 255.0
	local g = rgbaTable.g / 255.0
	local b = rgbaTable.b / 255.0
	local a = (rgbaTable.a or 255) / 255.0

	return LuaVec4(r, g, b, a)
end
