-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local function validate(hexString)
	if type(hexString) ~= "string" then
		return false
	elseif (#hexString ~= 7) and (#hexString ~= 9) then
		log.error("HexColor string must contain 7 (#RRGGBB) " ..
				"or 9 characters (#RRGGBBAA)")
		return false
	elseif hexString:sub(1, 1) ~= '#' then
		log.error('First character of an HexColor string must be a \'#\'')
		return false
	end

	return true
end

local function hexToNumber(hex, label)
	local number = tonumber("0x" .. hex)

	if not number then
		log.error("'" .. label ..
				"' component of HexString must be between 0x00 and 0xFF")
	end

	return number
end

return function(hexString)
	if not validate(hexString) then
		return nil
	end

	hexString = hexString:gsub("#","")
	local red   = hexToNumber(hexString:sub(1,2), "red")
	local green = hexToNumber(hexString:sub(3,4), "green")
	local blue  = hexToNumber(hexString:sub(5,6), "blue")

	local alpha = 255
	if #hexString == 8 then
		alpha = hexToNumber(hexString:sub(7,8), "alpha")
	end

	if (not red) or (not green) or (not blue) or (not alpha) then
		return nil
	end

	return {r = red, g = green, b = blue, a = alpha}
end
