-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local SignalInterceptor = class(function(self, signal, priority, fn, context)
	self._signal = signal
	self._priority = priority
	self._interceptFunction = fn
	self._context = context
	self._isActive = false
end)

function SignalInterceptor:getInterceptedSignal()
	return self._signal
end

function SignalInterceptor:activate()
	if not self:isActive() then
		self._isActive = true
		self._signal:add(self._interceptFunction, self._context, self._priority)
	end
end

function SignalInterceptor:deactivate()
	if self:isActive() then
		self._isActive = false
		self._signal:remove(self._interceptFunction, self._context)
	end
end

function SignalInterceptor:isActive()
	return self._isActive
end

function SignalInterceptor:dispose()
	self._signal:remove(self._interceptFunction, self._context)
end

return SignalInterceptor