/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_OTA_OTA_BINDINGS_LUA_FFI_VERSION_TABLE_SHARED_PTR_LUA_BINDING_H_
#define PLUGIN_OTA_OTA_BINDINGS_LUA_FFI_VERSION_TABLE_SHARED_PTR_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <bindings/NamespaceAliases.h>
#include <plugin/version/VersionTable.h>
#include <bindings/types/LuaReflectableValueMapBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA_SHARED_PTR(VersionTable, core);

namespace core
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct VersionTableSharedPtrUserData
		VersionTableSharedPtrUserData;

typedef struct ReflectableValueMapUserData
		ReflectableValueMapUserData;

PLUGINLUA_API void versionManager_VersionTableSharedPtr_gc(
		VersionTableSharedPtrUserData* self);

PLUGINLUA_API const char* versionManager_VersionTableSharedPtr_getVersionFor(
		VersionTableSharedPtrUserData* self, const char* pluginId);

PLUGINLUA_API bool versionManager_VersionTableSharedPtr_hasVersionFor(
		VersionTableSharedPtrUserData* self, const char* pluginId);

PLUGINLUA_API ReflectableValueMapUserData* versionManager_VersionTableSharedPtr_getVersionMap(
		VersionTableSharedPtrUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace core
} // namespace ignition

#endif // PLUGIN_OTA_OTA_BINDINGS_LUA_FFI_VERSION_TABLE_SHARED_PTR_LUA_BINDING_H_
