/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_LUA_BINDINGS_TYPES_TIMELINE_LUA_BINDING_H_
#define PLUGIN_LUA_BINDINGS_TYPES_TIMELINE_LUA_BINDING_H_

#include "ffi/LuaFFIUserData.h"
#include "LuaConfig.h"
#include <timeline/Timeline.h>
#include <bindings/NamespaceAliases.h>

namespace ignition
{

CREATE_FFI_USER_DATA(Timeline, lua);

namespace lua
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct TimelineUserData TimelineUserData;

PLUGINLUA_API size_t timeline_Timeline_startAction(
		TimelineUserData* self,
		const char* name);

PLUGINLUA_API void timeline_Timeline_stopActionWithId(
		TimelineUserData* self,
		const char* name,
		size_t id);

PLUGINLUA_API void timeline_Timeline_stopActionWithoutId(
		TimelineUserData* self,
		const char* name);

PLUGINLUA_API void timeline_Timeline_triggerInstantaneousAction(
		TimelineUserData* self,
		const char* name);

PLUGINLUA_API void timeline_Timeline_reset(
		TimelineUserData* self);

PLUGINLUA_API void timeline_Timeline_print(
		TimelineUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace lua
} // namespace ignition

#endif // PLUGIN_LUA_BINDINGS_TYPES_TIMELINE_LUA_BINDING_H_
