/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_LUA_BINDINGS_TYPES_VEC3_H_
#define PLUGIN_LUA_BINDINGS_TYPES_VEC3_H_

#include <glm/glm.hpp>
#include "LuaConfig.h"

namespace ignition
{
namespace lua
{

/* @begin_ffi_externs */

typedef struct LuaVec3
{
	float x, y, z;
} LuaVec3;

/* @end_ffi_externs */

namespace conversion
{
PLUGINLUA_API glm::vec3 toVec3(const LuaVec3&);
}

} // namespace lua
} // namespace ignition

#endif
