/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_LUA_BINDINGS_TYPES_LUA_REFLECTABLE_VALUE_VECTOR_BINDING_H_
#define PLUGIN_LUA_BINDINGS_TYPES_LUA_REFLECTABLE_VALUE_VECTOR_BINDING_H_

#include <meta/ReflectableValueVector.h>
#include "ffi/LuaFFIUserData.h"

#include <bindings/types/LuaReflectableValueBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA(ReflectableValueVector, core);

namespace core
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct ReflectableValueVectorUserData ReflectableValueVectorUserData;

PLUGINLUA_API ReflectableValueVectorUserData* core_ReflectableValueVector_new();
PLUGINLUA_API void core_ReflectableValueVector_gc(ReflectableValueVectorUserData* self);

PLUGINLUA_API ReflectableValueUserData* core_ReflectableValueVector_front(
		ReflectableValueVectorUserData* self);

PLUGINLUA_API ReflectableValueUserData* core_ReflectableValueVector_back(
		ReflectableValueVectorUserData* self);

PLUGINLUA_API ReflectableValueUserData* core_ReflectableValueVector_get(
		ReflectableValueVectorUserData* self,
		size_t index);

PLUGINLUA_API void core_ReflectableValueVector_set(
		ReflectableValueVectorUserData* self,
		size_t index,
		ReflectableValueUserData* value);

PLUGINLUA_API void core_ReflectableValueVector_push(
		ReflectableValueVectorUserData* self,
		ReflectableValueUserData* value);

PLUGINLUA_API void core_ReflectableValueVector_pop(
		ReflectableValueVectorUserData* self);

PLUGINLUA_API bool core_ReflectableValueVector_isEmpty(
		ReflectableValueVectorUserData* self);

PLUGINLUA_API size_t core_ReflectableValueVector_size(
		ReflectableValueVectorUserData* self);

/* @end_ffi_externs */

} /* extern "C" */
} /* namespace core */
} /* namespace ignition */

#endif /* PLUGIN_LUA_BINDINGS_TYPES_LUA_REFLECTABLE_VALUE_VECTOR_BINDING_H_ */
