/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_LUA_EXTENSIONS_UUID_EXTENSION_H_
#define IGNITION_LUA_EXTENSIONS_UUID_EXTENSION_H_

#include <lua.hpp>
#include <utils/UUID.h>

#include "extensions/LuaFfiExtension.h"
#include "LuaConfig.h"

namespace ignition
{
namespace lua
{

class PLUGINLUA_API UuidExtension : public LuaFfiExtension
{
	LUA_FFI_EXTENSION(UuidExtension);
	LUA_FFI_EXTENSION_SIMPLE_CONSTRUCTORS(UuidExtension);

public:
	static const std::string UUID_GLOBAL_NAME;
};

extern "C"
{
/* @begin_ffi_externs */

PLUGINLUA_API uint32_t lua_UuidExtension_generateNumber();

/* @end_ffi_externs */
}

} /* namespace lua */
} /* namespace ignition */

#endif /* IGNITION_LUA_EXTENSIONS_UUID_EXTENSION_H_ */
