/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_LUA_EXTENSIONS_TIMER_EXTENSION_H_
#define PLUGIN_LUA_EXTENSIONS_TIMER_EXTENSION_H_

#include <lua.hpp>

#include "extensions/LuaFfiExtension.h"

namespace ignition
{
namespace lua
{

class PLUGINLUA_API TimerExtension : public LuaFfiExtension
{
	LUA_FFI_EXTENSION(TimerExtension);
	LUA_FFI_EXTENSION_SIMPLE_CONSTRUCTORS(TimerExtension);

public:
	static const std::string TIMER_GLOBAL_NAME;
};

extern "C"
{
/* @begin_ffi_externs */

PLUGINLUA_API double lua_TimerExtension_getTimeInMilliseconds();

/* @end_ffi_externs */
}

} // namespace lua
} // namespace ignition

#endif // PLUGIN_LUA_EXTENSIONS_TIMER_EXTENSION_H_
