/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_BINDINGS_EXTENSIONS_TIMELINE_EXTENSION_H_
#define PLUGIN_INSPECTOR_BINDINGS_EXTENSIONS_TIMELINE_EXTENSION_H_

#include "LuaConfig.h"
#include <extensions/LuaExtension.h>
#include <ffi/LuaFFILibWrapper.h>
#include <utils/LuaRegistryRef.h>

namespace ignition
{

namespace core
{
class Timeline;
}

namespace lua
{

class IMetatabledClassInstance;

class PLUGINLUA_API TimelineExtension : public lua::LuaExtension
{
	LUA_EXTENSION(TimelineExtension);

public:
	static const std::string SHARED_LIBRARY_NAME;
	static const std::string API_NAMESPACE;
	static const std::string TIMELINE_NAME;

	TimelineExtension(lua::LuaState* state);
	~TimelineExtension();

	void setTimeline(core::Timeline* timeline);

	lua::LuaState* getLuaState();
	lua::LuaFFILibWrapper* getLibWrapper();

protected:
	void _configurePackagePath();

	void _addBindings();
	void _removeBindings();

	void _addClosureApi();
	void _removeClosureApi();

	void _bindClass(const std::string& className);

	void _passInstanceToLuaState(
			lua::IMetatabledClassInstance& instance,
			const std::string& className);

	core::Timeline* _timeline;

	lua::LuaRegistryRef _apiRef;
	lua::LuaFFILibWrapper _libWrapper;

	bool _isBound;
};

} // namespace lua
} // namespace ignition

#endif // PLUGIN_INSPECTOR_BINDINGS_EXTENSIONS_TIMELINE_EXTENSION_H_
