/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_LUA_EXTENSIONS_PLUGINPATH_EXTENSION_H_
#define IGNITION_LUA_EXTENSIONS_PLUGINPATH_EXTENSION_H_

#include <lua.hpp>

#include "extensions/LuaFfiExtension.h"
#include "LuaConfig.h"
#include "utils/LuaRegistryRef.h"

namespace ignition
{
namespace lua
{

class PLUGINLUA_API PluginsExtension : public LuaFfiExtension
{
	LUA_FFI_EXTENSION(PluginsExtension);

public:
	static const std::string PLUGINS_GLOBAL_NAME;

protected:
	PluginsExtension(lua::LuaState* state);

private:
	void _loadLuaFile();
	void _configureConventionConstants();

	LuaRegistryRef _pluginsTableRef;
};

extern "C"
{
/* @begin_ffi_externs */

PLUGINLUA_API const char* lua_PluginsExtension_resolvePath(const char* pluginUri);
PLUGINLUA_API const char* lua_PluginsExtension_getStaticAssetsPath(const char* pluginId);
PLUGINLUA_API const char* lua_PluginsExtension_getUserVarPath(const char* pluginId);
PLUGINLUA_API const char* lua_PluginsExtension_getBinaryPath(const char* pluginId);
PLUGINLUA_API const char* lua_PluginsExtension_getTestDataPath(const char* pluginId);

/* @end_ffi_externs */
}

} /* namespace lua */
} /* namespace ignition */

#endif /* IGNITION_LUA_EXTENSIONS_PLUGINPATH_EXTENSION_H_ */
