/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_OTA_OTA_BINDINGS_LUA_FFI_PLUGIN_VERSION_MANAGER_SHARED_PTR_LUA_BINDING_H_
#define PLUGIN_OTA_OTA_BINDINGS_LUA_FFI_PLUGIN_VERSION_MANAGER_SHARED_PTR_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <bindings/NamespaceAliases.h>
#include <bindings/types/VersionTableSharedPtrLuaBinding.h>
#include <plugin/PluginVersionManager.h>

namespace ignition
{

CREATE_FFI_USER_DATA_SHARED_PTR(PluginVersionManager, core);

namespace core
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct PluginVersionManagerSharedPtrUserData
		PluginVersionManagerSharedPtrUserData;

typedef struct VersionTableSharedPtrUserData
		VersionTableSharedPtrUserData;

PLUGINLUA_API PluginVersionManagerSharedPtrUserData*
		versionManager_PluginVersionManagerSharedPtr_getInstance();

PLUGINLUA_API void versionManager_PluginVersionManagerSharedPtr_gc(
		PluginVersionManagerSharedPtrUserData* self);

PLUGINLUA_API VersionTableSharedPtrUserData*
		versionManager_PluginVersionManagerSharedPtr_getVersionTable(
		PluginVersionManagerSharedPtrUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace core
} // namespace ignition

#endif // PLUGIN_OTA_OTA_BINDINGS_LUA_FFI_PLUGIN_VERSION_MANAGER_SHARED_PTR_LUA_BINDING_H_
