/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_LUA_BINDINGS_TYPES_VEC4_H_
#define PLUGIN_LUA_BINDINGS_TYPES_VEC4_H_

#include <glm/glm.hpp>
#include "LuaConfig.h"

namespace ignition
{
namespace lua
{

/* @begin_ffi_externs */

typedef struct LuaVec4
{
	float x, y, z, w;
} LuaVec4;

/* @end_ffi_externs */

namespace conversion
{
PLUGINLUA_API glm::vec4 toVec4(const LuaVec4&);
}

} // namespace lua
} // namespace ignition

#endif
