/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_LUA_BINDINGS_TYPES_VEC2_H_
#define PLUGIN_LUA_BINDINGS_TYPES_VEC2_H_

#include <glm/glm.hpp>
#include "LuaConfig.h"

namespace ignition
{
namespace lua
{



/* @begin_ffi_externs */

typedef struct LuaVec2
{
	float x, y;
} LuaVec2;

/* @end_ffi_externs */

namespace conversion
{
PLUGINLUA_API glm::vec2 toVec2(const LuaVec2&);
}

} // namespace lua
} // namespace ignition

#endif
