/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_LUA_BINDINGS_TYPES_LUA_REFLECTABLE_VALUE_MAP_BINDING_H_
#define PLUGIN_LUA_BINDINGS_TYPES_LUA_REFLECTABLE_VALUE_MAP_BINDING_H_

#include <meta/ReflectableValueMap.h>
#include "ffi/LuaFFIUserData.h"

#include <bindings/types/LuaReflectableValueBinding.h>
#include <bindings/types/LuaReflectableValueVectorBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA(ReflectableValueMap, core);

namespace core
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct ReflectableValueMapUserData ReflectableValueMapUserData;
typedef struct ReflectableValueVectorUserData ReflectableValueVectorUserData;

PLUGINLUA_API ReflectableValueMapUserData* core_ReflectableValueMap_new();
PLUGINLUA_API void core_ReflectableValueMap_gc(ReflectableValueMapUserData* self);

PLUGINLUA_API bool core_ReflectableValueMap_has(
		ReflectableValueMapUserData* self,
		const char* key);

PLUGINLUA_API ReflectableValueUserData* core_ReflectableValueMap_get(
		ReflectableValueMapUserData* self,
		const char* key);

PLUGINLUA_API void core_ReflectableValueMap_set(
		ReflectableValueMapUserData* self,
		const char* key,
		ReflectableValueUserData* value);

PLUGINLUA_API bool core_ReflectableValueMap_isEmpty(
		ReflectableValueMapUserData* self);

PLUGINLUA_API ReflectableValueVectorUserData* core_ReflectableValueMap_keys(
		ReflectableValueMapUserData* self);

/* @end_ffi_externs */

} /* extern "C" */
} /* namespace core */
} /* namespace ignition */

#endif /* PLUGIN_LUA_BINDINGS_TYPES_LUA_REFLECTABLE_VALUE_MAP_BINDING_H_ */
