/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_LUA_BINDINGS_TYPES_REFLECTABLEVALUEBINDING_H_
#define IGNITION_LUA_BINDINGS_TYPES_REFLECTABLEVALUEBINDING_H_

#include <meta/ReflectableValue.h>
#include "ffi/LuaFFIUserData.h"

#include <bindings/types/LuaVec2Binding.h>
#include <bindings/types/LuaVec3Binding.h>
#include <bindings/types/LuaVec4Binding.h>
#include <bindings/types/LuaRectBinding.h>
#include <bindings/types/LuaCuboidBinding.h>

namespace ignition
{

using core::ReflectableValue;
using namespace ::ignition::lua;

CREATE_FFI_USER_DATA(ReflectableValue, core);

namespace core
{

PLUGINLUA_API ReflectableValueUserData* createLuaOwnedReflectableValueUserData(
		const ReflectableValue* sourceValue);

extern "C"
{

/* @begin_ffi_externs */

typedef enum ReflectableValueType
{
	TYPE_BOOL,
	TYPE_INT,
	TYPE_UINT,
	TYPE_FLOAT,
	TYPE_DOUBLE,
	TYPE_VEC2,
	TYPE_VEC3,
	TYPE_VEC4,
	TYPE_RECT,
	TYPE_CUBOID,
	TYPE_STR,
	TYPE_ID,
	TYPE_NONE,
	TYPE_INVALID
} ReflectableValueType;

typedef struct ReflectableValueUserData ReflectableValueUserData;

// This typedef mirrors the one in core::UUID::ID_t - it's only here so that we've
// got something semantically similar to be able to use in the bindings below, as
// exposing the typedef that lives in UUID.h directly to Lua isn't possible (the
// LuaJIT FFI module only understands C syntax, so has no understanding of classes,
// namespaces etc.)
//
// If the typdef in core::UUID::ID_t is changed, this one must be changed too.
typedef uint32_t ID_t;

PLUGINLUA_API ReflectableValueUserData* core_ReflectableValue_new();
PLUGINLUA_API void core_ReflectableValue_gc(ReflectableValueUserData*);

PLUGINLUA_API bool core_ReflectableValue_getBool(ReflectableValueUserData*);
PLUGINLUA_API int core_ReflectableValue_getInt(ReflectableValueUserData*);
PLUGINLUA_API unsigned int core_ReflectableValue_getUint(ReflectableValueUserData*);
PLUGINLUA_API float core_ReflectableValue_getFloat(ReflectableValueUserData*);
PLUGINLUA_API double core_ReflectableValue_getDouble(ReflectableValueUserData*);
PLUGINLUA_API LuaVec2 core_ReflectableValue_getVec2(ReflectableValueUserData*);
PLUGINLUA_API LuaVec3 core_ReflectableValue_getVec3(ReflectableValueUserData*);
PLUGINLUA_API LuaVec4 core_ReflectableValue_getVec4(ReflectableValueUserData*);
PLUGINLUA_API LuaRect core_ReflectableValue_getRect(ReflectableValueUserData*);
PLUGINLUA_API LuaCuboid core_ReflectableValue_getCuboid(ReflectableValueUserData*);
PLUGINLUA_API const char* core_ReflectableValue_getString(ReflectableValueUserData*);
PLUGINLUA_API ID_t core_ReflectableValue_getId(ReflectableValueUserData*);

PLUGINLUA_API void core_ReflectableValue_setBool(ReflectableValueUserData*, bool);
PLUGINLUA_API void core_ReflectableValue_setInt(ReflectableValueUserData*, int);
PLUGINLUA_API void core_ReflectableValue_setUint(ReflectableValueUserData*, unsigned int);
PLUGINLUA_API void core_ReflectableValue_setFloat(ReflectableValueUserData*, float);
PLUGINLUA_API void core_ReflectableValue_setDouble(ReflectableValueUserData*, double);
PLUGINLUA_API void core_ReflectableValue_setVec2(ReflectableValueUserData*, LuaVec2);
PLUGINLUA_API void core_ReflectableValue_setVec3(ReflectableValueUserData*, LuaVec3);
PLUGINLUA_API void core_ReflectableValue_setVec4(ReflectableValueUserData*, LuaVec4);
PLUGINLUA_API void core_ReflectableValue_setRect(ReflectableValueUserData*, LuaRect);
PLUGINLUA_API void core_ReflectableValue_setCuboid(ReflectableValueUserData*, LuaCuboid);
PLUGINLUA_API void core_ReflectableValue_setString(ReflectableValueUserData*, const char*);
PLUGINLUA_API void core_ReflectableValue_setId(ReflectableValueUserData*, ID_t);

PLUGINLUA_API void core_ReflectableValue_erase(ReflectableValueUserData*);
PLUGINLUA_API bool core_ReflectableValue_isEmpty(ReflectableValueUserData*);
PLUGINLUA_API ReflectableValueType core_ReflectableValue_type(ReflectableValueUserData*);

/* @end_ffi_externs */

} /* extern "C" */
} /* namespace core */
} /* namespace ignition */

#endif /* IGNITION_LUA_BINDINGS_TYPES_REFLECTABLEVALUEBINDING_H_ */
