/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_LUA_EXTENSIONS_CRYPTO_EXTENSION_H_
#define IGNITION_LUA_EXTENSIONS_CRYPTO_EXTENSION_H_

#include <lua.hpp>
#include <crypto/HashedString.h>

#include "extensions/LuaFfiExtension.h"
#include "LuaConfig.h"

namespace ignition
{
namespace lua
{

class PLUGINLUA_API CryptoExtension : public LuaFfiExtension
{
	LUA_FFI_EXTENSION(CryptoExtension);
	LUA_FFI_EXTENSION_SIMPLE_CONSTRUCTORS(CryptoExtension);

public:
	static const std::string CRYPTO_GLOBAL_NAME;
};

extern "C"
{
/* @begin_ffi_externs */

PLUGINLUA_API uint32_t lua_CryptoExtension_djb2Hash(const char* input);

/* @end_ffi_externs */
}

} /* namespace lua */
} /* namespace ignition */

#endif /* IGNITION_LUA_EXTENSIONS_CRYPTO_EXTENSION_H_ */
