(function(global)
{
	function buildLogger(loggingFunction)
	{
		// Logging function that extends on what the built in Ignition one does
		// to print out the full contents of all arguments supplied.
		return function doLog(message)
		{
			var messages = Array.prototype.slice.call(arguments);
			var numArgs = messages.length;
			var i = 0;

			for (; i<numArgs; i++)
			{
				if (typeof messages[i] === 'object')
					messages[i] = JSON.stringify(messages[i], null, '\t');
			}

			loggingFunction(messages.join(' '));
		}
	}

	// Expose
	global.console =
	{
		log: buildLogger(log.console.debug),
		info: buildLogger(log.console.info),
		warn: buildLogger(log.console.warn),
		error: buildLogger(log.console.error)
	};
})(this);
