(function(global)
{
	const EVENTS =
	[
		'open',
		'close',
		'message',
		'fail'
	];

	function WebSocket(url)
	{
		this._client = new network.WebSocketClient();
		this._client.connect(url);

		EVENTS.forEach(_mapSignalToEvent.bind(this));
	}

	function _mapSignalToEvent(eventName)
	{
		var callbackName = 'on' + eventName;

		this._client[eventName].add(function()
		{
			if (typeof this[callbackName] === 'function')
				this[callbackName].apply(this, arguments);
		}.bind(this));
	}

	WebSocket.prototype.send = function(data)
	{
		this._client.send(data);
	};

	WebSocket.prototype.close = function(code)
	{
		this._client.disconnect(code);
	};

	// Expose
	global.WebSocket = WebSocket;
})(this);