/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_TRANSPORT_TRANSPORT_MANAGER_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_TRANSPORT_TRANSPORT_MANAGER_H_

#include <string>
#include <vector>

#include "inspector/InspectorConfig.h"
#include "inspector/transport/IInspectorTransport.h"

namespace ignition
{
namespace inspector
{

class PLUGININSPECTOR_API TransportManager
{
public:
	virtual ~TransportManager();

	void registerTransport(IInspectorTransport* transport);
	void unregisterTransport(IInspectorTransport* transport);

	virtual void send(const std::string& message);

	typedef std::vector<IInspectorTransport*> TransportsCollection;

	bool hasTransport(IInspectorTransport* transport) const;
	const TransportsCollection& getTransports() const;
	size_t numberOfTransports() const;

protected:
	TransportsCollection _transports;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_TRANSPORT_TRANSPORT_MANAGER_H_
