/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_INSPECTABLE_I_INSPECTOR_SERIALIZABLE_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_INSPECTABLE_I_INSPECTOR_SERIALIZABLE_H_

#include <string>

namespace ignition
{
namespace inspector
{

enum DetailLevel
{
	DETAIL_LEVEL_LOW,
	DETAIL_LEVEL_MEDIUM,
	DETAIL_LEVEL_HIGH,
	DETAIL_LEVEL_FULL
};

class IInspectorSerializable
{
public:
	virtual ~IInspectorSerializable() {}

	virtual std::string toDetailJson(
			DetailLevel detailLevel = DETAIL_LEVEL_FULL) const = 0;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_INSPECTABLE_I_INSPECTOR_SERIALIZABLE_H_
