/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_SENDER_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_SENDER_H_

#include "ChannelDefs.h"
#include "inspector/channels/messaging/Message.h"
#include "inspector/channels/messaging/responses/MessageResponse.h"

namespace ignition
{
namespace inspector
{

class IInspectorSerializable;

class IInspectorChannelSender
{
public:
	virtual ~IInspectorChannelSender() {}

	virtual void notify(
			const NotificationType& notification,
			const IInspectorSerializable& info) = 0;

	virtual void respond(
			Message::MessageId originalMessageId,
			Message::InspectorClientId requesterId,
			CommandTypeHash command,
			const MessageResponse& response) = 0;

	virtual const ChannelName& getName() const = 0;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_SENDER_H_
