/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_NOTIFIER_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_NOTIFIER_H_

#include "inspector/channels/ChannelDefs.h"
#include "inspector/channels/messaging/MessageInfo.h"

namespace ignition
{
namespace inspector
{
class InspectorChannelConnection;
class IInspectorChannelNotifier
{
public:
	virtual ~IInspectorChannelNotifier() {}
	virtual NotificationTypeVector getNotificationList() const = 0;

protected:
	virtual void setChannelConnection(InspectorChannelConnection* connection) = 0;
	friend class InspectorChannelConnection;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_NOTIFIER_H_
