/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_COMMAND_PROCESSOR_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_COMMAND_PROCESSOR_H_

#include <Function.h>

#include "inspector/channels/ChannelDefs.h"
#include "inspector/channels/messaging/Message.h"

namespace ignition
{
namespace inspector
{

class InspectorChannelConnection;

class CommandProcessor
{
public:
	CommandProcessor() {}
	virtual ~CommandProcessor() {}

	virtual void process(
			Message message,
			InspectorChannelConnection* channel) = 0;

	virtual void flush() = 0;

	virtual void setMessageCallback(
			core::function<void(const Message&)> messageCallback) = 0;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_CHANNEL_COMMAND_PROCESSOR_H_
