/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_TRANSPORT_I_INSPECTOR_TRANSPORT_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_TRANSPORT_I_INSPECTOR_TRANSPORT_H_

#include <string>

namespace ignition
{
namespace inspector
{

class IInspectorTransport
{
public:
	virtual ~IInspectorTransport() {}

	virtual void connect(const std::string& connectionInfo) = 0;
	virtual void disconnect() = 0;
	virtual void send(const std::string& message) = 0;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_TRANSPORT_I_INSPECTOR_TRANSPORT_H_
