/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_EVENTS_TRANSPORT_EVENT_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_EVENTS_TRANSPORT_EVENT_H_

#include "inspector/InspectorConfig.h"
#include <event/events/Event.h>
#include <event/EventHandler.h>

namespace ignition
{
namespace inspector
{

class PLUGININSPECTOR_API TransportEvent : public core::event::Event
{
	REGISTER_EVENT(TransportEvent);

public:
	static const core::event::EventName MESSAGE_RECEIVED;
    static const core::event::EventName CONNECTED;
    static const core::event::EventName DISCONNECTED;

	static TransportEvent* create(
			const core::event::EventName name,
			const core::UUID& sender,
			const std::string& message);

	static TransportEvent* clone(const TransportEvent& rhs);
	static TransportEvent& cast(core::event::Event& event);

	TransportEvent(const TransportEvent& other);

	void accept(
			core::event::EventHandler* const handler,
			core::event::Context& ctx);

	const std::string& getMessage();

protected:
	TransportEvent(
			const core::event::EventName name,
			const core::UUID& sender,
			const std::string& message);

	std::string _message;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_EVENTS_TRANSPORT_EVENT_H_
