/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_RESPONSES_MESSAGE_RESPONSE_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_RESPONSES_MESSAGE_RESPONSE_H_

#include "inspector/InspectorConfig.h"
#include <inspector/channels/messaging/MessageInfo.h>
#include <inspector/inspectables/IInspectable.h>

#include <string>

namespace ignition
{
namespace inspector
{

class PLUGININSPECTOR_API MessageResponse : public IInspectorSerializable
{
public:
	MessageResponse(const MessageInfo& info);
	MessageResponse(const std::string& info);
	MessageResponse(IInspectorSerializable* serializable);

	enum ResponseStatus
	{
		RESPONSE_STATUS_NULL,
		RESPONSE_STATUS_ASYNC,
		RESPONSE_STATUS_ERROR,
		RESPONSE_STATUS_INFO,
		RESPONSE_STATUS_STRING,
		RESPONSE_STATUS_SERIALIZABLE
	};

	ResponseStatus getStatus() const;

	std::string toDetailJson(
			DetailLevel detailLevel = DETAIL_LEVEL_FULL) const;

protected:
	// This constructor can only be called by NullMessageResponse()
	MessageResponse();

	ResponseStatus _status;
	std::string _body;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_RESPONSES_MESSAGE_RESPONSE_H_
