/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_MESSAGE_INFO_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_MESSAGE_INFO_H_

#include "inspector/InspectorConfig.h"
#include <meta/ReflectableValue.h>
#include <DataStructures.h>
#include <inspector/inspectables/IInspectorSerializable.h>

#include <string>

namespace ignition
{
namespace inspector
{

class PLUGININSPECTOR_API MessageInfo : public IInspectorSerializable
{
public:
	bool has(const std::string& key) const;
	const core::ReflectableValue& get(const std::string& key) const;
	void set(const std::string& key, const core::ReflectableValue& value);

	bool isEmpty() const;

	core::ReflectableValue& operator[](const std::string& key);
	const core::ReflectableValue& operator[](const std::string& key) const;

	std::string toDetailJson(DetailLevel detailLevel = DETAIL_LEVEL_FULL) const;

	typedef core::unordered_map<std::string,
			core::ReflectableValue>::iterator iterator;
	typedef core::unordered_map<std::string,
			core::ReflectableValue>::const_iterator constIterator;

	iterator begin();
	iterator end();
	
	constIterator begin() const;
	constIterator end() const;

private:
	core::unordered_map<std::string, core::ReflectableValue> _values;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_MESSAGE_INFO_H_
