/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_MESSAGE_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_MESSAGE_H_

#include "inspector/InspectorConfig.h"
#include <inspector/channels/ChannelDefs.h>
#include <inspector/channels/messaging/MessageInfo.h>

#include <stdint.h>

namespace ignition
{
namespace inspector
{

struct PLUGININSPECTOR_API Message
{
	typedef uint32_t MessageId;
	typedef uint32_t InspectorClientId;

	enum MessageType
	{
		MESSAGE_TYPE_NOTIFICATION,
		MESSAGE_TYPE_COMMAND,
		MESSAGE_TYPE_RESPONSE,
		MESSAGE_TYPE_ERROR
	};

	static const char* ID_KEY;
	static const char* RESPONDER_ID_KEY;
	static const char* REQUESTER_ID_KEY;
	static const char* TYPE_KEY;
	static const char* SUBTYPE_KEY;
	static const char* CHANNEL_KEY;
	static const char* INFO_KEY;
	static const char* ORIGINAL_ID_KEY;
	static const char* RESPONSE_STATUS_KEY;

	Message(
			MessageId id,
			InspectorClientId requesterId,
			MessageType type,
			crypto::hash_t subtype,
			ChannelNameHash channel,
			const MessageInfo& info);

	MessageId id;
	InspectorClientId requesterId;
	MessageType type;
	crypto::hash_t subtype;
	ChannelNameHash channel;
	MessageInfo info;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_MESSAGING_MESSAGE_H_
