/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_INTERCEPTORS_I_COMMAND_INTERCEPTOR_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_INTERCEPTORS_I_COMMAND_INTERCEPTOR_H_

#include "inspector/channels/ChannelDefs.h"
#include "inspector/channels/messaging/responses/MessageResponse.h"

namespace ignition
{
namespace inspector
{

class MessageInfo;
class InspectorChannelConnection;

class ICommandInterceptor
{
public:
	virtual ~ICommandInterceptor() {}

	virtual MessageResponse intercept(
			CommandTypeHash commandHash,
			const MessageInfo& info,
			InspectorChannelConnection* channel) = 0;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_INTERCEPTORS_I_COMMAND_INTERCEPTOR_H_
