/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_QUEUE_COMMAND_PROCESSOR_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_QUEUE_COMMAND_PROCESSOR_H_

#include "DataStructures.h"

#include <core/thread/Mutex.h>

#include "inspector/InspectorConfig.h"
#include "inspector/channels/ChannelDefs.h"
#include "inspector/channels/CommandProcessor.h"
#include "inspector/channels/messaging/Message.h"

class InspectorChannelConnection;

namespace ignition
{
namespace inspector
{

class PLUGININSPECTOR_API QueueCommandProcessor: public CommandProcessor
{
public:
	QueueCommandProcessor(const CommandTypeVector& commandsToQueue);
	virtual ~QueueCommandProcessor() {}

	virtual void process(
			Message message,
			InspectorChannelConnection* channel);

	virtual void flush();

	virtual void setMessageCallback(
    		core::function<void(const Message&)> messageCallback);

private:
	core::unordered_set<CommandTypeHash> _commandsToQueue;
	core::queue<Message> _messageQueue;
	core::function<void(const Message&)> _messageCallback;
	core::thread::Mutex _messageQueueMutex;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_CHANNEL_QUEUE_COMMAND_PROCESSOR_H_
