/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_RECEIVER_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_RECEIVER_H_

#include "inspector/channels/ChannelDefs.h"
#include "inspector/channels/messaging/Message.h"
#include "inspector/channels/messaging/MessageInfo.h"
#include "inspector/channels/messaging/responses/MessageResponse.h"
#include "inspector/channels/messaging/responses/NullMessageResponse.h"
#include "inspector/inspectables/IInspectable.h"

namespace ignition
{
namespace inspector
{

class IInspectorChannelReceiver
{
public:
	virtual ~IInspectorChannelReceiver() {}

	virtual IInspectable* getInspectable(InspectableId id) const = 0;

	// The receiver can implement and execute any specific command that is
	// not already handled by the interceptors.
	// (see internal/inspector/channels/interceptors)
	virtual MessageResponse execute(
			const CommandType& command,
			const MessageInfo& info,
			Message::MessageId originalMessageId,
			Message::InspectorClientId requesterId) = 0;

	virtual CommandTypeVector getCommandList() const = 0;

	virtual bool isInspectable() const
	{
		return true;
	}
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_I_INSPECTOR_CHANNEL_RECEIVER_H_
