/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_CHANNEL_DEFS_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_CHANNEL_DEFS_H_

#include <crypto/HashedString.h>
#include <vector>

namespace ignition
{
namespace inspector
{

typedef crypto::HashedString ChannelName;
typedef crypto::HashedString NotificationType;
typedef crypto::HashedString CommandType;

typedef crypto::hash_t ChannelNameHash;
typedef crypto::hash_t NotificationTypeHash;
typedef crypto::hash_t CommandTypeHash;

typedef std::vector<CommandType> CommandTypeVector;
typedef std::vector<NotificationType> NotificationTypeVector;

// Built in notification types
const NotificationType MESSAGE_RESPONSE = "messageResponse";

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_CHANNELS_CHANNEL_DEFS_H_
