/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */
#ifndef PLUGIN_INSPECTOR_BINDINGS_SM_INSPECTOR_EXTENSION_H_
#define PLUGIN_INSPECTOR_BINDINGS_SM_INSPECTOR_EXTENSION_H_

#include "inspector/channels/ChannelManager.h"
#include <sm/Extension.h>

namespace ignition
{
namespace inspector
{
namespace sm
{

class InspectorExtension : public javascript::sm::Extension
{
public:
	InspectorExtension(
			javascript::sm::SpiderMonkeyEnvironment* env,
			ChannelManagerPtr channelManager);

	void sendAsyncResponse(
			const std::string& channelName,
			const crypto::HashedString& commandType,
			int32_t originalMessageId,
			int32_t requesterId,
			const std::string& result);

private:
	ChannelManagerPtr _channelManager;
};

} // namespace sm
} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_BINDINGS_SM_INSPECTOR_EXTENSION_H_
