/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_I_INSPECTOR_H_
#define PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_I_INSPECTOR_H_

#include <plugin/IPlugin.h>

#include "inspector/channels/ChannelDefs.h"
#include "inspector/channels/CommandProcessor.h"

namespace ignition
{
namespace inspector
{

class InspectorChannelConnection;
class IInspectorChannelReceiver;
class IInspectorChannelNotifier;
class IInspectorTransport;

class IInspector : public core::plugin::IPlugin
{
	REGISTER_PLUGIN_NAME(com.amazon.ignition.framework.inspector);

public:
	IInspector(){}
	virtual ~IInspector() {};

	virtual InspectorChannelConnection* openChannel(
			const ChannelName& name,
			IInspectorChannelReceiver* receiver,
			IInspectorChannelNotifier* notifier = nullptr) = 0;
	virtual void closeChannel(const ChannelName& name) = 0;
	virtual void closeChannel(InspectorChannelConnection* channel) = 0;

	virtual	void registerTransport(IInspectorTransport* transport) = 0;
	virtual	void unregisterTransport(IInspectorTransport* transport) = 0;

	virtual void processTransportEvents() = 0;
	virtual void flushMessages(const ChannelName& name) = 0;

	virtual void registerCommandProcessor(
			const ChannelName& name,
			CommandProcessor* processor) = 0;
};

} // namespace inspector
} // namespace ignition

#endif // PLUGIN_INSPECTOR_EXTERNAL_INSPECTOR_I_INSPECTOR_H_
