--[[
--
--	Builds the global namespace for the input extension.
--
--	This function also returns a table containing protected management methods
--	for the extension.
--
--]]
return function (namespace)
	assert(type(namespace) == 'string', 'Namespace must be a string')
	assert(_G[namespace] == nil, 'Global style namespace must not already exist')
	constants = require("external/inputConstants")

	local input =
	{
		keyCodes = constants.keyCodes,
		keyModifiers = constants.keyModifiers,
		keyDownSignal = nil,
		keyUpSignal = nil,
		keyPressSignal = nil,
		longKeyPressSignal = nil,
		mouseDownSignal = nil,
		mouveUpSignal = nil,
		mouveScrollSignal = nil,
		moveMoveSignal = nil
	}
	_G[namespace] = input

	local _inputFacade

	function input.setRepeatEnabled(value)
		_inputFacade:setRepeatEnabled(value)
	end

	function input.setKeyRepeatInitialDelay(initialDelay)
		_inputFacade:setKeyRepeatInitialDelay(initialDelay)
	end

	function input.setKeyRepeatRepeatDelay(repeatDelay)
		_inputFacade:setKeyRepeatRepeatDelay(repeatDelay)
	end

	function input.setKeyRepeatRepeatDelay(repeatDelay)
		_inputFacade:setKeyRepeatRepeatDelay(repeatDelay)
	end

	function input.addRepeatableKey(key)
		_inputFacade:addRepeatableKey(key)
	end

	function input.removeRepeatableKey(key)
		_inputFacade:removeRepeatableKey(key)
	end

	function input.addRepeatableKeyGroup(keyGroup)
		_inputFacade:addRepeatableKeyGroup(keyGroup)
	end

	function input.removeRepeatableKeyGroup(keyGroup)
		_inputFacade:removeRepeatableKeyGroup(keyGroup)
	end

	function input.simulateKeyPress(keyCode, keyModifier)
		_inputFacade:simulateKeyPress(keyCode, keyModifier)
	end

	function input.isArrowKey(keyCode)
		return ((keyCode == input.keyCodes.KEY_UP) or
				(keyCode == input.keyCodes.KEY_DOWN) or
				(keyCode == input.keyCodes.KEY_RIGHT) or
				(keyCode == input.keyCodes.KEY_LEFT))
	end

	-- Functions for the native extension to call in order to configure various
	-- aspects of the input namespace.
	return
	{
		-- Sets the InputManager instance in use by the Input plugin.
		setInputFacade = function (value)
			_inputFacade = value
		end,

		-- Sets the KeyDownSignal instance in use by the Input plugin.
		setKeyDownSignal = function(value)
			input.keyDownSignal = value
		end,

		-- Sets the KeyUpSignal instance in use by the Input plugin.
		setKeyUpSignal = function(value)
			input.keyUpSignal = value
		end,

		-- Sets the KeyPressSignal instance in use by the Input plugin.
		setKeyPressSignal = function(value)
			input.keyPressSignal = value
		end,

		-- Sets the LongKeyPressSignal instance in use by the Input plugin.
		setLongKeyPressSignal = function(value)
			input.longKeyPressSignal = value
		end,

		setMouseDownSignal = function(value)
			input.mouseDownSignal = value
		end,

		setMouseUpSignal = function(value)
			input.mouseUpSignal = value
		end,

		setMouseScrollSignal = function(value)
			input.mouseScrollSignal = value
		end,

		setMouseMoveSignal = function(value)
			input.mouseMoveSignal = value
		end
	}
end
