/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_INPUT_BINDINGS_LUA_INPUT_MANAGER_LUA_BINDING_H_
#define PLUGIN_INPUT_BINDINGS_LUA_INPUT_MANAGER_LUA_BINDING_H_

#include "InputFacade.h"
#include "ffi/LuaFFIUserData.h"
#include "InputConfig.h"

namespace ignition
{

CREATE_FFI_USER_DATA(InputFacade, input);

namespace input
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct InputFacadeUserData InputFacadeUserData;

void PLUGININPUT_API input_InputFacade_setRepeatEnabled(
		InputFacadeUserData* self,
		const bool value);

void PLUGININPUT_API input_InputFacade_setKeyRepeatInitialDelay(
		InputFacadeUserData* self,
		const int initialDelay);

void PLUGININPUT_API input_InputFacade_setKeyRepeatRepeatDelay(
		InputFacadeUserData* self,
		const int repeatDelay);

void PLUGININPUT_API input_InputFacade_addRepeatableKey(
		InputFacadeUserData* self,
		const int key);

void PLUGININPUT_API input_InputFacade_removeRepeatableKey(
		InputFacadeUserData* self,
		const int key);

void PLUGININPUT_API input_InputFacade_addRepeatableKeyGroup(
		InputFacadeUserData* self,
		const int keyGroup);

void PLUGININPUT_API input_InputFacade_removeRepeatableKeyGroup(
		InputFacadeUserData* self,
		const int keyGroup);

void PLUGININPUT_API input_InputFacade_simulateKeyPress(
		InputFacadeUserData* self,
		const int keyCode,
		const int keyModifier);

void PLUGININPUT_API input_InputFacade_simulateKeyDown(
		InputFacadeUserData* self,
		const int keyCode,
		const int keyModifier);

void PLUGININPUT_API input_InputFacade_simulateKeyUp(
		InputFacadeUserData* self,
		const int keyCode,
		const int keyModifier);

/* @end_ffi_externs */

} // extern "C"
} // namespace input
} // namespace ignition

#endif // PLUGIN_INPUT_BINDINGS_LUA_INPUT_MANAGER_LUA_BINDING_H_
