/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_FOCUS_BINDINGS_LUA_FOCUS_MANAGER_LUA_BINDING_H_
#define PLUGIN_FOCUS_BINDINGS_LUA_FOCUS_MANAGER_LUA_BINDING_H_

#include "FocusConfig.h"
#include "focus/FocusManager.h"

#include <ffi/LuaFFIUserData.h>
#include <bindings/types/LuaVec3Binding.h>

#include <scene/nodes/SceneNodeLuaBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA(FocusManager, focus);

// Name mangling is disabled in the extern section, so we need to
// introduce scene::SceneNodeUserData in this scope
using scene::SceneNodeUserData;
using namespace ::ignition::lua;

namespace focus
{
extern "C"
{
/* @begin_ffi_externs */
typedef struct FocusManagerUserData FocusManagerUserData;

PLUGINFOCUS_API void focus_FocusManager_dispatchJsSignal(
		FocusManagerUserData* self,
		const char* signalName,
		SceneNodeUserData* node);

PLUGINFOCUS_API void focus_FocusManager_dispatchMouseJsSignal(
		FocusManagerUserData* self,
		const char* signalName,
		SceneNodeUserData* node,
		float x, float y);

PLUGINFOCUS_API void focus_FocusManager_dispatchMouseMoveJsSignal(
		FocusManagerUserData* self,
		const char* signalName,
		SceneNodeUserData* node,
		float x, float y, float dx, float dy);

PLUGINFOCUS_API const float* focus_FocusManager_getSuitableFocusableNodes(
		FocusManagerUserData* self,
		SceneNodeUserData* currentlySelectedNode,
		LuaVec3 direction,
		int coordSpace);

PLUGINFOCUS_API void focus_FocusManager_updateFocusableNodeList(
		FocusManagerUserData* self, bool forceUpdate);
/* @end_ffi_externs */
} // extern "C"
} // namespace focus
} // namespace ignition

#endif // PLUGIN_FOCUS_BINDINGS_LUA_FOCUS_MANAGER_LUA_BINDING_H_
