-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local TreeUtils = {}

function TreeUtils.getPathToRoot(node)
	local pathToRoot = {}
	if node ~= nil then
		parent = node:getParent()
		while parent ~= nil do
			table.insert(pathToRoot, parent)
			parent = parent:getParent()
		end
	end
	return pathToRoot
end

function TreeUtils.getPathIntersection(pathA, pathB)
	if (pathA == nil) or (pathB == nil) then
		return nil, nil, nil
	end

	local lookup = {}
	for i, parentNode in ipairs(pathA) do
		lookup[parentNode:getId()] = i
	end

	local intersection = nil
	local intersectionPointA = nil
	local intersectionPointB = nil
	for i, parentNode in ipairs(pathB) do
		local intersectionPoint = lookup[parentNode:getId()]
		if intersectionPoint ~= nil then
			intersection = parentNode
			intersectionPointA = intersectionPoint
			intersectionPointB = i
			break
		end
	end

	return intersection, intersectionPointA, intersectionPointB
end

function TreeUtils.commonAncestor(nodeA, nodeB)
	if (nodeA == nil) or (nodeB == nil) then
		return nil
	end

	local pathToRootA = TreeUtils.getPathToRoot(nodeA)
	local pathToRootB = TreeUtils.getPathToRoot(nodeB)

	local lowestCommonAncestor, _1, _2 =
			TreeUtils.getPathIntersection(pathToRootA, pathToRootB)

	return lowestCommonAncestor
end

return TreeUtils