-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local TreeUtils = plugins.focus:require('utils.TreeUtils')
local FocusTagsManager = class(function(self)
end)

function FocusTagsManager:updateTags(
		oldFocusedNode, newFocusedNode, tagName, propagateToAncestors)
	local commonParent = TreeUtils.commonAncestor(oldFocusedNode, newFocusedNode)

	local breakpoint = nil
	if commonParent ~= nil then
		breakpoint = commonParent:getId()
	end

	if propagateToAncestors == nil then
		propagateToAncestors = true
	end

	if oldFocusedNode then
		self:_applyRecursiveOperation(oldFocusedNode.removeTag,
				oldFocusedNode, tagName, breakpoint, propagateToAncestors)
	end

	if newFocusedNode then
		self:_applyRecursiveOperation(newFocusedNode.addTag,
				newFocusedNode, tagName, breakpoint, propagateToAncestors)
	end
end

function FocusTagsManager:_applyRecursiveOperation(
		addOrRemoveFunc, node, tagName, breakpoint, bubbleUp)
	addOrRemoveFunc(node, tagName) -- TODO Deprecate (IGN-1304)
	addOrRemoveFunc(node, ':' .. tagName)

	if bubbleUp then
		self:_bubbleUpOperation(addOrRemoveFunc, node, tagName, breakpoint)
	end
end

function FocusTagsManager:_bubbleUpOperation(
		addOrRemoveFunc, node, tagName, breakpoint)
	local ancestorTag = 'descendant-' .. tagName
	local parent = node:getParent()
	while (parent ~= nil) and (parent:getId() ~= breakpoint) do
		addOrRemoveFunc(parent, ancestorTag) -- TODO Deprecate (IGN-1304)
		addOrRemoveFunc(parent, ':' .. ancestorTag)
		parent = parent:getParent()
	end
end

return FocusTagsManager
